<?php
// Include the connection file
include 'conn.php';

// Get the raw POST data
$jsonData = file_get_contents('php://input');

// Decode the JSON data into a PHP associative array
$data = json_decode($jsonData, true);

// Define the response array
$response = [];

// Log the incoming data for debugging
error_log(print_r($data, true));

// Check if the required data is provided
if (isset($data['vtype']) && isset($data['voucherno'])) {
    $vtype = $data['vtype'];
    $olabno = $data['voucherno'];

    // Ensure that table_initial is set
    if (!isset($table_initial)) {
        $response = ["status" => "error", "message" => "Table prefix not set."];
        echo json_encode($response);
        exit();
    }

    // Query to check if the report is signed
    $checkQuery = "SELECT signedate FROM " . $table_initial . "tbpatients WHERE labno = ? AND vtype = ? AND issigned = 1";
    if ($stmt = $conn->prepare($checkQuery)) {
        $stmt->bind_param("is", $olabno, $vtype);
        $stmt->execute();
        $stmt->store_result();

        // If a signed report is found, update the tbTestOrder table
        if ($stmt->num_rows > 0) {
            $stmt->bind_result($signedate);
            $stmt->fetch();
            $response = [
                "labno" => $olabno,
                "vtype" => $vtype,
                "signedate" => $signedate,
                "status" => "updated"
            ];
        } else {
            $response = ["status" => "not_signed", "message" => "Report not signed."];
        }
        $stmt->close();
    } else {
        $response = ["status" => "error", "message" => "Database query failed: " . $conn->error];
    }
} else {
    $response = ["status" => "error", "message" => "Invalid input data."];
}

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the database connection
$conn->close();
?>
