<?php
// Include the connection file
include 'conn.php';

// Get the raw POST data
$jsonData = file_get_contents('php://input');

// Decode the JSON data into a PHP associative array
$data = json_decode($jsonData, true);

// Check if data is received properly
if ($data) {
    // Check if a record with the same `labno` and `vtype` already exists
    $checkQuery = "SELECT COUNT(*) FROM " . $table_initial . "tbpatients WHERE labno = ? AND vtype = ?";
    if ($stmt = $conn->prepare($checkQuery)) {
        $stmt->bind_param("is", $data['labno'], $data['vtype']);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();

        if ($count > 0) {
            // Record exists, so perform an UPDATE
            $updateQuery = "UPDATE " . $table_initial . "tbpatients 
                            SET tdate = ?, HSREGNO = ?, SAMPLENO = ?, MOBILENO = ?, PNAME = ?, FNAME = ?, GENDER = ?, AGEY = ?, 
                            CONSULTANT = ?, EMAIL = ?, ADDRESS = ?, SampleFrom = ?, TOTALBILL = ?, DiscPer = ?, DiscAmount = ?, 
                            cDiscPer = ?, cDiscAmount = ?, NETBILL = ?, NETPAID = ?, REMAMOUNT = ?, mlno = ?, issigned = ?, signedby = ?, 
                            signedate = ?, senttime = ?, sentby = ?, hmrno = ?, issenttosign = ?, sentto = ?
                            WHERE labno = ? AND vtype = ?";
            
            if ($stmt = $conn->prepare($updateQuery)) {
                $stmt->bind_param(
                    "sssssssssssssssssssssssssssssss", 
                    $data['tdate'], 
                    $data['HSREGNO'], 
                    $data['SAMPLENO'], 
                    $data['MOBILENO'], 
                    $data['PNAME'], 
                    $data['FNAME'], 
                    $data['GENDER'], 
                    $data['AGEY'], 
                    $data['CONSULTANT'], 
                    $data['EMAIL'], 
                    $data['ADDRESS'], 
                    $data['SampleFrom'], 
                    $data['TOTALBILL'], 
                    $data['DiscPer'], 
                    $data['DiscAmount'], 
                    $data['cDiscPer'], 
                    $data['cDiscAmount'], 
                    $data['NETBILL'], 
                    $data['NETPAID'], 
                    $data['REMAMOUNT'], 
                    $data['mlno'], 
                    $data['issigned'], 
                    $data['signedby'], 
                    $data['signedate'], 
                    $data['senttime'], 
                    $data['sentby'], 
                    $data['hmrno'], 
                    $data['issenttosign'], 
                    $data['sentto'], 
                    $data['labno'], 
                    $data['vtype']
                );

                if ($stmt->execute()) {
                    echo json_encode(["status" => "success", "message" => "Data updated successfully"]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Failed to update data"]);
                }

                $stmt->close();
            } else {
                echo json_encode(["status" => "error", "message" => "Failed to prepare update statement"]);
            }
        } else {
            // Record doesn't exist, so perform an INSERT
            $insertQuery = "INSERT INTO " . $table_initial . "tbpatients (labno, vtype, tdate, HSREGNO, SAMPLENO, MOBILENO, PNAME, FNAME, GENDER, AGEY, CONSULTANT, EMAIL, ADDRESS, SampleFrom, TOTALBILL, DiscPer, DiscAmount, 
 cDiscPer, cDiscAmount, NETBILL, NETPAID, REMAMOUNT, mlno, issigned, signedby, signedate, senttime, sentby, hmrno, issenttosign, sentto) 
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
            if ($stmt = $conn->prepare($insertQuery)) {
                $stmt->bind_param(
                    "sssssssssssssssssssssssssssssss", 
                    $data['labno'], 
                    $data['vtype'], 
                    $data['tdate'], 
                    $data['HSREGNO'], 
                    $data['SAMPLENO'], 
                    $data['MOBILENO'], 
                    $data['PNAME'], 
                    $data['FNAME'], 
                    $data['GENDER'], 
                    $data['AGEY'], 
                    $data['CONSULTANT'], 
                    $data['EMAIL'], 
                    $data['ADDRESS'], 
                    $data['SampleFrom'], 
                    $data['TOTALBILL'], 
                    $data['DiscPer'], 
                    $data['DiscAmount'], 
                    $data['cDiscPer'], 
                    $data['cDiscAmount'], 
                    $data['NETBILL'], 
                    $data['NETPAID'], 
                    $data['REMAMOUNT'], 
                    $data['mlno'], 
                    $data['issigned'], 
                    $data['signedby'], 
                    $data['signedate'], 
                    $data['senttime'], 
                    $data['sentby'], 
                    $data['hmrno'], 
                    $data['issenttosign'], 
                    $data['sentto']
                );

                if ($stmt->execute()) {
                    echo json_encode(["status" => "success", "message" => "Data inserted successfully"]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Failed to insert data"]);
                }

                $stmt->close();
            } else {
                echo json_encode(["status" => "error", "message" => "Failed to prepare insert statement"]);
            }
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to prepare check statement"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid data"]);
}

// Close the database connection
$conn->close();
?>
