<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conn.php';

if (!isset($_GET['id'])) {
    die("Invalid request: ID parameter missing");
}

$labno = intval($_GET['id']);
$vtype = 'TO'; // Assuming 'TO' as vtype for this example. Change it accordingly if it's dynamic.

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['logout'])) {
    session_destroy();
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['sign_report'])) {
    $signedate = date('Y-m-d H:i:s');
    $updateSql = "UPDATE " . $table_initial . "tbpatients SET issigned = 1, signedate = ? WHERE labno = ?";
    $updateStmt = $conn->prepare($updateSql);
    $updateStmt->bind_param('si', $signedate, $labno);

    if ($updateStmt->execute()) {
        echo "<div class='alert alert-success'>Report Approved successfully.</div>";
    } else {
        echo "<div class='alert alert-danger'>Error Approving report: " . $updateStmt->error . "</div>";
    }

    $updateStmt->close();
}

// Fetch patient details
$patientSql = "SELECT * FROM " . $table_initial . "tbpatients WHERE labno = ?";
$patientStmt = $conn->prepare($patientSql);
$patientStmt->bind_param('i', $labno);
$patientStmt->execute();
$patientResult = $patientStmt->get_result();
$patient = $patientResult->fetch_assoc();

// Fetch test details
$sql = "SELECT * FROM " . $table_initial . "tbtests WHERE labno = ? ORDER BY testhead,torder";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $labno);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patient Test Details</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .test-group {
            border: 1px solid #dee2e6;
            margin-bottom: 20px;
            padding: 10px;
            border-radius: 5px;
        }
        .test-group h5 {
            margin-bottom: 15px;
        }
        .buttons {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center my-4">Patient Test Details</h2>
        
        <div class="buttons">
            <a href="patients.php" class="btn btn-secondary">Home</a>
            <form method="POST" class="d-inline">
                <button type="submit" name="logout" class="btn btn-danger">Logout</button>
            </form>
        </div>
        
        <div class="patient-details mb-4">
            <h4>Patient Information</h4>
            <p><strong>Lab Number:</strong> <?php echo $patient['labno']; ?></p>
            <p><strong>Visit Type:</strong> <?php echo $patient['vtype']; ?></p>
            <p><strong>Patient Name:</strong> <?php echo $patient['PNAME']; ?></p>
            <p><strong>Consultant:</strong> <?php echo $patient['CONSULTANT']; ?></p>
            <p><strong>Date:</strong> <?php echo $patient['tdate']; ?></p>
            <p><strong>Approved:</strong> <?php echo $patient['issigned'] ? 'Yes' : 'No'; ?></p>
        </div>
        
        <?php
        $currentTestHead = '';
        $currentTestSubhead = '';

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                if ($row['testhead'] !== $currentTestHead) {
                    if ($currentTestHead !== '') {
                        echo '</tbody></table></div>';
                    }
                    $currentTestHead = $row['testhead'];
                    echo "<div class='test-group'>";
                    echo "<h5>{$currentTestHead}</h5>";
                    echo "<table class='table table-striped'>";
                    echo "<thead><tr><th></th><th>Test Name</th><th>Result</th><th>Reference Value</th><th>Units</th><th>Order</th><th>Normal</th><th>Critical</th></tr></thead>";
                    echo "<tbody>";
                }
                
                if (!empty($row['testsubhead']) && $row['testsubhead'] !== $currentTestSubhead) {
    $currentTestSubhead = $row['testsubhead'];
    echo "<tr><td colspan='8'><strong>{$currentTestSubhead}</strong></td></tr>";
}


                echo "<tr>";
                echo "<td></td>";
                if (!empty($row['testsubhead'])){
                    echo "<td>&nbsp;&nbsp;&nbsp;&nbsp;{$row['testname']}</td>";

                } else
                {
                echo "<td>{$row['testname']}</td>";    
                }
                
                echo "<td>{$row['RESULT']}</td>";
                echo "<td>{$row['REFVALUE']}</td>";
                echo "<td>{$row['units']}</td>";
                echo "<td>{$row['torder']}</td>";
                echo "<td>" . ($row['ISNORMAL'] ? 'Yes' : 'No') . "</td>";
                echo "<td>" . ($row['ISCRITICAL'] ? 'Yes' : 'No') . "</td>";
                echo "</tr>";
            }
            echo '</tbody></table></div>';
        } else {
            echo "<div class='alert alert-warning'>No test details found for this patient.</div>";
        }

        $stmt->close();
        $conn->close();
        ?>

        <form method='POST' class="mt-4">
            <button type='submit' name="sign_report" class='btn btn-primary'>Approve Report</button>
        </form>
    </div>
</body>
</html>
