<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'php_errors.log');

// Include the connection file
include 'conn.php';

// Log the received JSON data
$jsonData = file_get_contents('php://input');
error_log("Received JSON: " . $jsonData);

// Decode the JSON data into a PHP associative array
$data = json_decode($jsonData, true);

// Check if data is received properly
if ($data === null) {
    error_log("Failed to decode JSON: " . json_last_error_msg());
    die(json_encode(["status" => "error", "message" => "Invalid JSON data"]));
}

// Log the decoded data
error_log("Decoded JSON: " . print_r($data, true));

// Check for missing fields
$requiredFields = [
    'labno', 'vtype', 'tdate', 'HSREGNO', 'SAMPLENO', 'MOBILENO', 'PNAME', 'FNAME', 'GENDER', 'AGEY',
    'CONSULTANT', 'EMAIL', 'ADDRESS', 'SampleFrom', 'TOTALBILL', 'DiscPer', 'DiscAmount', 'cDiscPer',
    'cDiscAmount', 'NETBILL', 'NETPAID', 'REMAMOUNT', 'mlno', 'issigned', 'signedby',
    'senttime', 'sentby', 'hmrno', 'issenttosign', 'sentto'
];

foreach ($requiredFields as $field) {
    if (!isset($data[$field])) {
        error_log("Missing field in JSON: " . $field);
        die(json_encode(["status" => "error", "message" => "Missing field: " . $field]));
    }
}

// Prepare the SQL query
$query = "INSERT INTO alazeemtbpatients (
            labno, vtype, tdate, HSREGNO, SAMPLENO, MOBILENO, PNAME, FNAME, GENDER, AGEY, 
            CONSULTANT, EMAIL, ADDRESS, SampleFrom, TOTALBILL, DiscPer, DiscAmount, 
            cDiscPer, cDiscAmount, NETBILL, NETPAID, REMAMOUNT, mlno, issigned, signedby, 
            senttime, sentby, hmrno, issenttosign, sentto
          ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
          )
          ON DUPLICATE KEY UPDATE
            tdate = VALUES(tdate),
            HSREGNO = VALUES(HSREGNO),
            SAMPLENO = VALUES(SAMPLENO),
            MOBILENO = VALUES(MOBILENO),
            PNAME = VALUES(PNAME),
            FNAME = VALUES(FNAME),
            GENDER = VALUES(GENDER),
            AGEY = VALUES(AGEY),
            CONSULTANT = VALUES(CONSULTANT),
            EMAIL = VALUES(EMAIL),
            ADDRESS = VALUES(ADDRESS),
            SampleFrom = VALUES(SampleFrom),
            TOTALBILL = VALUES(TOTALBILL),
            DiscPer = VALUES(DiscPer),
            DiscAmount = VALUES(DiscAmount),
            cDiscPer = VALUES(cDiscPer),
            cDiscAmount = VALUES(cDiscAmount),
            NETBILL = VALUES(NETBILL),
            NETPAID = VALUES(NETPAID),
            REMAMOUNT = VALUES(REMAMOUNT),
            mlno = VALUES(mlno),
            issigned = VALUES(issigned),
            signedby = VALUES(signedby),
            senttime = VALUES(senttime),
            sentby = VALUES(sentby),
            hmrno = VALUES(hmrno),
            issenttosign = VALUES(issenttosign),
            sentto = VALUES(sentto)";

// Prepare the statement
if ($stmt = $conn->prepare($query)) {
    error_log("Query prepared successfully: " . $query);
} else {
    error_log("Failed to prepare query: " . $conn->error);
    die(json_encode(["status" => "error", "message" => "Failed to prepare query"]));
}

// Bind parameters
$stmt->bind_param(
    "ssssssssssssssssssssssssssssss", // 30 placeholders
    $data['labno'], 
    $data['vtype'], 
    $data['tdate'], 
    $data['HSREGNO'], 
    $data['SAMPLENO'], 
    $data['MOBILENO'], 
    $data['PNAME'], 
    $data['FNAME'], 
    $data['GENDER'], 
    $data['AGEY'], 
    $data['CONSULTANT'], 
    $data['EMAIL'], 
    $data['ADDRESS'], 
    $data['SampleFrom'], 
    $data['TOTALBILL'], 
    $data['DiscPer'], 
    $data['DiscAmount'], 
    $data['cDiscPer'], 
    $data['cDiscAmount'], 
    $data['NETBILL'], 
    $data['NETPAID'], 
    $data['REMAMOUNT'], 
    $data['mlno'], 
    $data['issigned'], 
    $data['signedby'], 
    $data['senttime'], 
    $data['sentby'], 
    $data['hmrno'], 
    $data['issenttosign'], 
    $data['sentto']
);
// Execute the query
// Log the query and parameters
error_log("Query: " . $query);
error_log("Parameters: " . print_r($data, true));

// Execute the query
if ($stmt->execute()) {
    error_log("Query executed successfully");
    echo json_encode(["status" => "success", "message" => "Data processed successfully"]);
} else {
    error_log("Failed to execute query: " . $stmt->error);
    echo json_encode(["status" => "error", "message" => "Failed to process data"]);
}

// Close the statement
$stmt->close();

// Close the database connection
$conn->close();
?>